//=============================================================================
// Kuro_OriginalParams.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/01/26 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc くろあめ工房独自メソッド定義
 * @target MZ
 * @author くろあめ
 *
 * @help
 * このプラグインは、くろあめ工房作品で使用する
 * 各種計算式参照用のメソッドを定義します
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {
// 戦闘計算用パラメータ
Object.defineProperties(Game_Enemy.prototype, {
    
    power: {
        get: function() {
            return ((this.atk * 3) + this.luk) / 5;
        },
        configurable: true
    },
    
    magic: {
        get: function() {
            return ((this.mat * 3) + this.luk) / 5;
        },
        configurable: true
    },
    
    guard: {
        get: function() {
            return ((this.mat * 2.25) + (this.agi * 1.25)) / 4;
        },
        configurable: true
    },
    
    // EVAsion rate 再定義 回避率は95%を限界とする
    eva: {
        get: function() {
            return Math.min(this.xparam(1),0.95);
        },
        configurable: true
    }
    
});

Object.defineProperties(Game_Actor.prototype, {
    
    power: {
        get: function() {
            return (((this.atk * 3) + this.luk) / 4) + (this.level * 2);
        },
        configurable: true
    },
    
    magic: {
        get: function() {
            return (((this.mat * 3) + this.luk) / 5) + (this.level * 2);
        },
        configurable: true
    },
    
    guard: {
        get: function() {
            return (((this.mat * 2) + this.agi) / 4) + this.level;
        },
        configurable: true
    },
    
    // EVAsion rate 再定義 回避率は95%を限界とする
    eva: {
        get: function() {
            return Math.min(this.xparam(1),0.95);
        },
        configurable: true
    }
    
});



// 呪毒のダメージ算出（付与が味方の場合）
Game_Actor.prototype.curseVenomCalc = function(trg) {
    var dam = trg.mhp * 10 / 100;
    var SlipDivision = trg.getSlipDivision();
    var SlipPush =  trg.getSlipPush();
    
    if(SlipDivision > 0){
        dam = dam / SlipDivision;
    } 
    if(SlipPush > 0){
        dam = dam * SlipPush;
    }
    dam += this.luk * 8;
    // ここまで基礎ダメージ算出
    // ここからクリティカル判定
    var cricnt = 1;
    var crtMax = 3;
    
    for(cricnt; cricnt<=crtMax; cricnt++){
        if(Math.random() < (this.cri / cricnt)){
            //cricntをカウントアップするだけでいいので何もしない
        }else{
            break;
        }
    }
    dam = dam * (100 + ((cricnt - 1) * 10)) / 100 * -1;
    
    var amp = Math.floor(Math.max((Math.abs(dam) * 15) / 100, 0));
    var v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;
    dam = dam >= 0 ? dam + v : dam - v;
    return Math.round(dam);
};


// 呪毒のダメージ算出（付与が敵の場合）
Game_Enemy.prototype.curseVenomCalc = function(trg) {
    var dam = trg.mhp * 5 / 100;
    var SlipDivision = trg.getSlipDivision();
    var SlipPush =  trg.getSlipPush();
    
    if(SlipDivision > 0){
        dam = dam / SlipDivision;
    } 
    if(SlipPush > 0){
        dam = dam * SlipPush;
    }
    
    dam += this.luk * 2;
    
    // ここまで基礎ダメージ算出
    // ここからクリティカル判定
    var cricnt = 1;
    var crtMax = 3;
    
    for(cricnt; cricnt<=crtMax; cricnt++){
        if(Math.random() < (this.cri / cricnt)){
            //cricntをカウントアップするだけでいいので何もしない
        }else{
            break;
        }
    }
    dam = dam * (100 + ((cricnt - 1) * 10)) / 100 * -1;
    
    var amp = Math.floor(Math.max((Math.abs(dam) * 15) / 100, 0));
    var v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;
    dam = dam >= 0 ? dam + v : dam - v;
    
    return Math.round(dam);
};



// 逃走率を200%に変更
BattleManager.makeEscapeRatio = function() {
    this._escapeRatio = 2.0;
};

// 被弾時のTP回復量を下方修正
Game_Battler.prototype.chargeTpByDamage = function(damageRate) {
    const value = Math.floor(15 * damageRate * this.tcr);
    this.gainSilentTp(value);
};


// 名前入力ウィンドウのフェイス表示位置調整
Window_NameEdit.prototype.refresh = function() {
    this.contents.clear();
    this.drawActorFace(this._actor, 150, 30);
    for (let i = 0; i < this._maxLength; i++) {
        this.drawUnderline(i);
    }
    for (let j = 0; j < this._name.length; j++) {
        this.drawChar(j);
    }
    const rect = this.itemRect(this._index);
    this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
};

// 「最強装備」を封印
Window_EquipCommand.prototype.maxCols = function() {
    return 2;
};

Window_EquipCommand.prototype.makeCommandList = function() {
    this.addCommand(TextManager.equip2, "equip");
    //this.addCommand(TextManager.optimize, "optimize");
    this.addCommand(TextManager.clear, "clear");
};

/* 以下、オプション画面のレイアウト調整（すべて再定義） */

// オプション項目の最大表示数調整
Scene_Options.prototype.maxCommands = function() {
    // Increase this value when adding option items.
    return 14;
};

// オプション音量の変動を10%刻みに
Window_Options.prototype.volumeOffset = function() {
    return 10;
};

// 13項目表示させるために、表示内容をちょっとずつ圧縮
Window_Options.prototype.lineHeight = function() {
    return 29;
};
Window_Options.prototype.itemPadding = function() {
    return 6;
};

Window_Options.prototype.resetFontSettings = function() {
    this.contents.fontFace = $gameSystem.mainFontFace();
    this.contents.fontSize = $gameSystem.mainFontSize() - 3;
    this.resetTextColor();
};



// コモンイベント呼び出し時に、呼び出したコモンイベントのIDを特定の変数に格納する
const _Game_Interpreter_command117_kuro = Game_Interpreter.prototype.command117;
Game_Interpreter.prototype.command117 = function(params) {
    const lastCommon = 18;
    $gameVariables.setValue(lastCommon, params[0]);
    _Game_Interpreter_command117_kuro.apply(this, arguments);
    return true;
};

// すべてのエネミーは、指定したIDの武器の特徴を引き継ぐ
// 指定ID：255
const _Game_Enemy_traitObjects_kuro = Game_Enemy.prototype.traitObjects;
Game_Enemy.prototype.traitObjects = function() {
  let objects = _Game_Enemy_traitObjects_kuro.call(this);
  //指定した武器のオブジェクトを取得
  Array.prototype.push.apply(objects, [$dataWeapons[255]]);
  return objects;
};

// 特定のスイッチがONの時は、場所移動時のマップ名表示を強制でOFFにする
// 特定スイッチID：8
Window_MapName.prototype.refresh = function() {
    this.contents.clear();
    if ($gameMap.displayName() && !$gameSwitches.value(8)) {
        const width = this.innerWidth;
        this.drawBackground(0, 0, width, this.lineHeight());
        this.drawText($gameMap.displayName(), 0, 0, width, "center");
    }
};

// バトルログ用の制御文字追加

const _Window_Base_convertEscapeCharacters_kuro = Window_Base.prototype.convertEscapeCharacters;
Window_Base.prototype.convertEscapeCharacters = function(text) {
    text = text.replace(/\\SK\[(\d+)\]/gi, (_, p1) =>
        this.getBattleLogSkillName(parseInt(p1))
    );
    text = text.replace(/\\SKR\[(\d+)\]/gi, (_, p1) =>
        this.getBattleLogSkillNameRecover(parseInt(p1))
    );
    text = _Window_Base_convertEscapeCharacters_kuro.apply(this, arguments);
    return text;
}

Window_Base.prototype.getBattleLogSkillName = function(target_id) {
    const item = $dataSkills[target_id];
    if(!item){
        return "";
    }
    return "\\I["+ item.iconIndex + "]\\B[15]\\C[14]" + item.name + "\\D\\C[0]";
}
Window_Base.prototype.getBattleLogSkillNameRecover = function(target_id) {
    const item = $dataSkills[target_id];
    if(!item){
        return "";
    }
    return "\\I["+ item.iconIndex + "]\\B[19]\\C[29]" + item.name + "\\D\\C[0]";
}

// バトルマネージャ追加、マップBGM/BGSのクリア
BattleManager.saveBgmAndBgsClear = function() {
    this._mapBgm = null;
    this._mapBgs = null;
};

// HPドレインも攻撃スキルと判定
Game_Action.prototype.isDamage = function() {
    return this.checkDamageType([1, 2, 5]);
};

// HPドレインも攻撃スキルと同じ演出を呼び出す
Window_BattleLog.prototype.displayHpDamage = function(target) {
    if (target.result().hpAffected) {
        if (target.result().hpDamage > 0 ) { //&& !target.result().drain) {
            this.push("performDamage", target);
        }
        if (target.result().hpDamage < 0) {
            this.push("performRecovery", target);
        }
        this.push("addText", this.makeHpDamageText(target));
    }
};

// ステート付与時の運気関連度変更
Game_Action.prototype.lukEffectRate = function(target) {
    var ret = 1.0;
    var retdiv = 0.5;
    ret = this.subject().luk / target.luk;
    
    if(this.subject().luk > target.luk){
        retdiv = ret - 1.0;
        retdiv /= 2;
        ret = Math.min(1.0 + retdiv, 2.0);
    }else{
        retdiv = 1.0 - ret;
        retdiv /= 2;
        ret = Math.max(1.0 - retdiv, 0.5);
    }
    //console.log("行動者：" + this.subject().name() + " / 対象：" + target.name());
    //console.log(ret);
    
    return ret;
    //return Math.max(1.0 + (this.subject().luk - target.luk) * 0.001, 0.0);
};

// アクターの戦闘力スコア取得
Game_Actor.prototype.getBattleScore = function() {
  let total = 0;
  total += this.mhp;
  total += this.mmp * 10;
  total += this.atk * 10;
  total += this.mat * 10;
  total += this.agi * 10;
  total += this.luk * 10;
  total += parseInt(this.cri * 300);
  total += parseInt(this.hit * 200);
  total += parseInt(this.eva * 500);
  total += this.dispCriMagni() * 30;
  return total;
};

/*
Game_System.prototype.mainFontFace = function() {
    return "rmmz-mainfont, " + $dataSystem.advanced.fallbackFonts ;
};
*/
// 再定義 バトルログの敵味方の名前を色文字表示に
/*
Window_BattleLog.prototype.displayItemMessage = function(fmt, subject, item) {
    if (fmt) {
        let subjectName = "\\C[2]" + subject.name() + "\\C[0]";
        this.push("addText", fmt.format(subjectName, item.name));
    }
};
*/

// オーバーライド 保証行動回数の定義
// クイックスキル使用時に行動回数が再計算されるため
// 一度出した最大行動回数は保証する仕組みを実装する
const _Game_Battler_initMembers_kop = Game_Battler.prototype.initMembers;
Game_Battler.prototype.initMembers = function() {
    _Game_Battler_initMembers_kop.call(this);
    this.lastRandomPlusAct = 0;
    this.lastFixPlusAct = 0;
};


// 新規定義 保証行動回数のクリア
Game_Battler.prototype.clearPlusAct = function() {
    this.lastRandomPlusAct = 0;
    this.lastFixPlusAct = 0;
    //console.log(this.name()+":clearPlusAct!");
};

// 再定義 保証行動回数のクリア
Game_Battler.prototype.makeActions = function() {
    this.clearActions();
    this.clearPlusAct(); // KURO仕様 保証行動回数のクリア追加
    if (this.canMove()) {
        const actionTimes = this.makeActionTimes();
        this._actions = [];
        for (let i = 0; i < actionTimes; i++) {
            this._actions.push(new Game_Action(this));
        }
    }
};

Game_Battler.prototype.makeActionTimes = function() {
    //console.log(this.name()+":makeAction!");
    var randomPlusAct = 0;
    var fixPlusAct = 0;
    var sumActNum = 0;
    const actionPlusSet = this.actionPlusSet();
    for (let i = 0; i < actionPlusSet.length; i++) {
       if(actionPlusSet[i] >= 1.0){
           fixPlusAct += 1;
       }
       else if(Math.random() < actionPlusSet[i]){
           randomPlusAct += 1;
       };
    }
    if(this.lastRandomPlusAct < randomPlusAct){
        this.lastRandomPlusAct = randomPlusAct;
    }
    else{
        randomPlusAct = this.lastRandomPlusAct;
    }
    if(this.lastFixPlusAct < fixPlusAct){
        this.lastFixPlusAct = fixPlusAct;
    }
    else{
        fixPlusAct = this.lastFixPlusAct;
    }
    //console.log(this.name()+"の追加行動判定",this.lastRandomPlusAct,this.lastFixPlusAct,randomPlusAct,fixPlusAct);
    sumActNum = Math.max(fixPlusAct + randomPlusAct + 1,1);
    //console.log(this.name()+"の行動回数："+String(sumActNum));
    //console.log(this._actions);
    return sumActNum;
};


// 行動キャンセル時に行動内容もクリアする、クイックスキル使用時に行動設定済みと見なされないようにする処置

Game_Actor.prototype.selectPreviousCommand = function() {
    //console.log("SelectPreviousCommand");
    //console.log(this._actions);
    //console.log(this._actionInputIndex);
    this._actions[this._actionInputIndex] = new Game_Action(this); //最後の決定行動を一回空っぽにする
    if (this._actionInputIndex > 0) {
        this._actionInputIndex--;
        return true;
    } else {
        return false;
    }
};


// メニュー画面でTP満タンの状態でもTP回復アイテム使えちゃう問題への対応

Game_Action.prototype.isTpRecover = function() {
    return this.item().effects.some(effect => effect.code == Game_Action.EFFECT_GAIN_TP);
};
/*
Game_Action.prototype.testApply = function(target) {
    return (
        this.testLifeAndDeath(target) &&
        ($gameParty.inBattle() ||
            (this.isHpRecover() && target.hp < target.mhp)   ||
            (this.isMpRecover() && target.mp < target.mmp)   ||
            (this.isTpRecover() && target.tp < target.maxTp) || 
            this.hasItemAnyValidEffects(target))
    );
};
*/
Game_Action.prototype.testItemEffect = function(target, effect) {
    
    switch (effect.code) {
        case Game_Action.EFFECT_RECOVER_HP:
            return (
                target.hp < target.mhp || effect.value1 < 0 || effect.value2 < 0
            );
        case Game_Action.EFFECT_RECOVER_MP:
            return (
                target.mp < target.mmp || effect.value1 < 0 || effect.value2 < 0
            );
        case Game_Action.EFFECT_ADD_STATE:
            return !target.isStateAffected(effect.dataId);
        case Game_Action.EFFECT_REMOVE_STATE:
            return target.isStateAffected(effect.dataId);
        case Game_Action.EFFECT_ADD_BUFF:
            return !target.isMaxBuffAffected(effect.dataId);
        case Game_Action.EFFECT_ADD_DEBUFF:
            return !target.isMaxDebuffAffected(effect.dataId);
        case Game_Action.EFFECT_REMOVE_BUFF:
            return target.isBuffAffected(effect.dataId);
        case Game_Action.EFFECT_REMOVE_DEBUFF:
            return target.isDebuffAffected(effect.dataId);
        case Game_Action.EFFECT_LEARN_SKILL:
            return target.isActor() && !target.isLearnedSkill(effect.dataId);
        // TPの判定追加
        case Game_Action.EFFECT_GAIN_TP:
            return (
                target.tp < target.maxTp() || effect.value1 < 0
            );
        default:
            return true;
    }
};

// 高難易度時、敵能力下駄履かせ機能
// 難易度プラグインの難易度が、特定の数値（難易度）以上の時
// すべての敵の基礎ステータスに、倍率ではない固定の数値を追加します

const HighRankBoostLine = [10000,200,200,0,200,0,200,200]; // 左から、HP、MP、攻撃、防御、魔力、魔防、素早、運気　の下駄履かせ値
const HighRankBoostLineBoss = [100000,200,200,0,200,0,200,200]; // ボス用 メモ欄に<BossType>タグが記述されている場合、こっちが適用される
const DifficultlyThreshold = 4;

Game_Enemy.prototype.paramBasePlus = function(paramId) {
    return Math.max(0, this.paramBase(paramId) + this.paramPlus(paramId) + this.highRankBoost(paramId));
};

Game_Enemy.prototype.highRankBoost = function(paramId) {
    const boostLine = (this.enemy() && this.enemy().meta && this.enemy().meta.BossType) ? HighRankBoostLineBoss : HighRankBoostLine;
    return $gameSystem.difficultyId() >= DifficultlyThreshold ? boostLine[paramId] : 0;
};

// スムーズログとの連携、エンドフェイズ判定用のフラグを追加
const _BattleManager_initMembers_kop = BattleManager.initMembers;
BattleManager.initMembers = function() {
  _BattleManager_initMembers_kop.call(this);
  this._onEndPhase = false;
};

const _BattleManager_updateStart_kop = BattleManager.updateStart;
BattleManager.updateStart = function() {
    this._onEndPhase = false;
    _BattleManager_updateStart_kop.call(this);
};

const _BattleManager_endAllBattlersTurn_kop = BattleManager.endAllBattlersTurn;
BattleManager.endAllBattlersTurn = function() {
  this._onEndPhase = true;
  _BattleManager_endAllBattlersTurn_kop.call(this);
};

BattleManager.onEndPhase = function() {
  return this._onEndPhase;
};


// スキル画面のアクター表示を変更
Window_SkillStatus.prototype.refresh = function() {
    Window_StatusBase.prototype.refresh.call(this);
    if (this._actor) {
        const x = this.colSpacing() / 2;
        const h = this.innerHeight;
        const y = h / 2 - this.lineHeight() * 1.5;
        this.drawActorFace(this._actor, x + 1, 0, 144, h);
        this.drawActorSimpleStatus(this._actor, x + 180, y);
    }
};

Window_SkillStatus.prototype.drawActorSimpleStatus = function(actor, x, y) {
    const lineHeight = this.lineHeight();
    const x2 = x + 180;
    this.drawActorName(actor, x - 80, y - 10);
    this.drawActorLevel(actor, x - 180, y + 80);
    //this.drawActorIcons(actor, x, y + lineHeight * 2);
    //this.drawActorClass(actor, x2, y);
    this.placeBasicGauges(actor, x - 80, y + lineHeight, 10);
    
    this.drawStatusParams(actor, x + 80, y, 2);
    this.drawStatusParams(actor, x + 80, y + lineHeight, 7);
    this.drawHitrate(actor, x + 80, y + lineHeight * 2);
    this.drawCriticalrates(actor, x + 235, y + 20);

};

Window_SkillStatus.prototype.drawActorLevel = function(actor, x, y) {
    this.changeTextColor(ColorManager.systemColor());
    this.drawText(TextManager.levelA, x, y, 48);
    this.resetTextColor();
    this.drawText(actor.level, x + 40, y, 36, "right");
};

Window_SkillStatus.prototype.drawStatusParams = function(actor, x, y, paramId) {
    const name = TextManager.param(paramId);
    const value = this._actor.param(paramId);
    this.changeTextColor(ColorManager.systemColor());
    this.drawText(name + "：", x, y, 80);
    this.resetTextColor();
    this.drawText(value, x + 70, y, 60, "right");
};

Window_SkillStatus.prototype.drawHitrate = function(actor, x, y) {
    const value = Math.floor(this._actor.xparam(0) * 100);
    this.changeTextColor(ColorManager.systemColor());
    this.drawText("命中：", x, y, 80);
    this.resetTextColor();
    this.drawText(String(value) + "%" , x + 70, y, 60, "right");
};
Window_SkillStatus.prototype.drawCriticalrates = function(actor, x, y) {
    const lineHeight = this.lineHeight();
    const value = Math.floor(this._actor.xparam(2) * 100);
    const value2 = this._actor.dispCriMagni();
    this.changeTextColor(ColorManager.systemColor());
    this.drawText("必殺率/倍率", x, y, 120, "center");
    this.resetTextColor();
    this.drawText(String(value) + "% / " + String(value2) + "%", x, y + lineHeight, 120, "center");
};


// オートバトル行動決定
// 連続行動時の二手目以降に、それまで消費したMP/TPを加味して行動選択する
// また、連続行動中にRT持ちの同じスキルを重複選択させない
Game_Actor.prototype.makeAutoBattleActions = function() {
    //console.log("call makeAutoBattleActions");
    //console.log(this.name());
    let tempActor = JsonEx.makeDeepCopy(this);
    for (let i = 0; i < this.numActions(); i++) {
        const list = tempActor.makeActionList();
        //console.log(list);
        let maxValue = -Number.MAX_VALUE;
        var setActionItem = null;
        for (const action of list) {
            var value = -Number.MAX_VALUE;
            console.log()
            if(this.isCanSetCoolDownSkill(action._item) && this.isNotQuickSkill(action._item)){
                value = action.evaluate();
            }else{
                //console.log(" === Is Set Skill!! === ");
                //console.log(action._item._itemId);
            }
            if (value > maxValue) {
                maxValue = value;
                this.setAction(i, action);
                //console.log(action._item);
                setActionItem = action._item;
            }
            BattleManager.clearOnslaught(); // 系統連撃機構対応、オート行動選定中のオンスロート値クリア
        }
        if(setActionItem._dataClass && setActionItem._itemId && setActionItem._dataClass == "skill" ){
            //console.log($dataSkills[setActionItem._itemId]);
            tempActor.paySkillCost($dataSkills[setActionItem._itemId]);
        }
    }
    delete tempActor;
    this.setActionState("waiting");
};

// 既にオート選択されたRTスキルかどうかのチェック
Game_Actor.prototype.isCanSetCoolDownSkill = function(setActionItem) {
    var skill;
    if(setActionItem._dataClass && setActionItem._itemId && setActionItem._dataClass == "skill" ){
        skill = $dataSkills[setActionItem._itemId];
        if(skill.meta.cooldownTurn){
            for (let i = 0; i < this._actions.length; i++) {
                if(this._actions[i]._item._dataClass &&
                   this._actions[i]._item._dataClass == "skill"){
                   if(this._actions[i]._item._itemId && skill.id){
                       if(this._actions[i]._item._itemId == skill.id){
                           return false;
                       }
                   }
                }
            }
        }
    }
    return true;
};

// クイックスキルかどうかのチェック、クイックスキルはオートバトルの行動候補対象外
Game_Actor.prototype.isNotQuickSkill = function(setActionItem) {
    var skill;
    if(setActionItem._dataClass && setActionItem._itemId && setActionItem._dataClass == "skill" ){
        skill = $dataSkills[setActionItem._itemId];
        if(skill.meta.QuickSkill){
            return false;
        }
    }
    return true;
};

// ウィンドウの開閉をVXA基準に合わせる
Window_Base.prototype.updateOpen = function() {
    if (this._opening) {
        this.openness += 48;
        if (this.isOpen()) {
            this._opening = false;
        }
    }
};

Window_Base.prototype.updateClose = function() {
    if (this._closing) {
        this.openness -= 48;
        if (this.isClosed()) {
            this._closing = false;
        }
    }
};


// 装備アイテムウィンドウのソート順を、１：魔法防御の高い順、２：ID順に変更する

Window_EquipItem.prototype.makeItemList = function() {
    Window_ItemList.prototype.makeItemList.call(this);
    this._data.sort((a, b) => {
      if (a === null || b === null){
        return 0;
      } 
      if (a.params[5] === b.params[5]) {
        return a.id - b.id;
      }
      return b.params[5] - a.params[5];
    });
};

/*
// 最終的な武器防具の選択カーソル位置が保存されない件
Window_EquipItem.prototype.selectLast = function() {
    const index = this._data.indexOf($gameParty.lastItem());
    this.forceSelect(index >= 0 ? index : 0);
};
*/

})();

